#include "General.h"
#include "MapStartingCredits.h"
#include "gmgame.h"


class MapStartingCredits : public Plugin
{
public:
	int StartingCredits, DefaultStartingCredits;

	MapStartingCredits()
	{
		RegisterEvent(EVENT_GLOBAL_INI,this);
		RegisterEvent(EVENT_LOAD_LEVEL_HOOK,this);
		RegisterEvent(EVENT_MAP_INI,this);
	}
	~MapStartingCredits()
	{
		UnregisterEvent(EVENT_GLOBAL_INI,this);
		UnregisterEvent(EVENT_LOAD_LEVEL_HOOK,this);
		UnregisterEvent(EVENT_MAP_INI,this);
	}

	virtual void OnLoadGlobalINISettings(INIClass *SSGMIni)
	{
		DefaultStartingCredits = The_Cnc_Game()->StartingCredits;
		const char* MapName = Get_Map(Get_Current_Map_Index());
		StartingCredits = SSGMIni->Get_Int("MapStartingCredits", MapName, -1);
	}

	virtual void OnLoadMapINISettings(INIClass *SSGMIni)
	{
		const char* MapName = Get_Map(Get_Current_Map_Index());
		StartingCredits = SSGMIni->Get_Int("MapStartingCredits", MapName, -1);
	}

	virtual void OnLoadLevel()
	{
		if (StartingCredits != -1)
		{
			The_Cnc_Game()->StartingCredits = StartingCredits;
		}
		else
		{
			The_Cnc_Game()->StartingCredits = DefaultStartingCredits;
		}
	}

};

MapStartingCredits mapStartingCredits;

extern "C" __declspec(dllexport) Plugin* Plugin_Init()
{
	return &mapStartingCredits;
}
